raw_data = readmatrix('34.3m cutback.dat');
wavelength = raw_data(:,1);


tiledlayout(1,1)

signal1 = (raw_data(:,4)+raw_data(:,6))/2; 
signal2 = (raw_data(:,8)+raw_data(:,10))/2;
noise = raw_data(:,2);

p = polyfit(wavelength,noise,1);
f = polyval(p,wavelength);


fig1 = figure('Color','w');
x0=10;
y0=10;

width=1500;
height=600;

nexttile
hold on
box on
plot(wavelength,(10*log10(signal1)),'LineWidth',3,'Color','b');
plot(wavelength,(10*log10(signal2)),'LineWidth',3,'Color','r');
plot(wavelength,(10*log10(noise)),'LineWidth',3,'Color','k');
xlabel('Wavelength / nm')
ylabel('Signal (dB)')
% title('Transmission')
xlim([180 450])


txt1 = '\leftarrow 34.3m';
t1 = text(wavelength(41),10*log10(signal1(18)),txt1,'FontSize',26);

txt2 = '\leftarrow 17.6m';
t2 = text(wavelength(92),10*log10(signal1(20)),txt2,'FontSize',26);

txt3 = '\downarrow Background';
t3 = text(280,-22,txt3,'FontSize',26);

ax = gca;
ax.LineWidth = 2;
txt4 = '(a)';
t4 = text(200,-5,txt4,'FontSize',28);

set(gca,'XMinorTick','on','YMinorTick','on')
set(gca,'FontSize',28)
set(gcf,'position',[x0,y0,width,height])
set(gca,'color','w')
hold off

% noise = noise - f;
% signal1 = signal1 - f;
% signal2 = signal2 - f;
% loss1 = (10*log10(signal2./signal1))/16.7;
% nexttile
% hold on
% plot(wavelength,loss1,'LineWidth',3,'Color','k')
% % title('Attenuation')
% box on
% xlabel('Wavelength / nm')
% ylabel('Attenuation (dB/m)')
% xlim([180 450])
% ylim([0 1])
% 
% set(gca,'XMinorTick','on','YMinorTick','on')
% set(gca,'FontSize',26)
% set(gcf,'position',[x0,y0,width,height])
% x = [243 269 269 243];
% y = [0 0 1 1];
% patch(x,y,'black','FaceAlpha',.3,'EdgeAlpha',.5)
% 
% x2 = [180 203 203 180];
% y2 = [0 0 1 1];
% patch(x2,y2,'black','FaceAlpha',.3,'EdgeAlpha',.5)
% 
% x2 = [407 450 450 407];
% y2 = [0 0 1 1];
% patch(x2,y2,'black','FaceAlpha',.3,'EdgeAlpha',.5)
% 
% 
% txt4 = '(b)';
% t4 = text(215,0.875,txt4,'FontSize',28);
% 
% ax = gca;
% ax.LineWidth = 2;
% hold off


